#include <stdio.h>
#include <string.h>

#define MAX 210

typedef struct {
    int cod;
    char name[8];
    int grau;
    int v;
    int ativ;
    int rem;
} disciplina;

disciplina vdisc[MAX];
int adisc[MAX][MAX];
int ndisc;

int listadisc[MAX];
int sizelista;

disciplina semestre[MAX][15];
int discsem[MAX];
int nsemestre;

int finddisc(char str[8]) {
    for (int i = 0; i < ndisc; i++) {
        if (strcmp(str, vdisc[i].name) == 0) {
            return i;
        }
    }
    return -1;
}

void DFS_Visit(int u) {
    int depend = 0;
    vdisc[u].v = 1;

    for (int i = 0; i < vdisc[u].grau; i++) {
        if (vdisc[adisc[u][i]].ativ)
            depend = 1;

        if (!vdisc[adisc[u][i]].v && vdisc[adisc[u][i]].ativ) {
            DFS_Visit(adisc[u][i]);
        }
    }

    if (!depend) {
        vdisc[u].rem = 1;
        listadisc[sizelista] = u;
        sizelista++;
    }
}

int DFS() {
    int thereway = 0;
    for (int i = 0; i < ndisc; i++) {
        vdisc[i].v = 0;
    }
    for (int i = 0; i < ndisc; i++) {
        if (!vdisc[i].v && vdisc[i].ativ) {
            thereway = 1;
            DFS_Visit(i);
        }
    }
    return thereway;
}

void ordenar() {
    int tmp;
    for (int i = 0; i < sizelista - 1; i++) {
        for (int j = i + 1; j < sizelista; j++) {
            if (listadisc[i] > listadisc[j]) {
                tmp = listadisc[i];
                listadisc[i] = listadisc[j];
                listadisc[j] = tmp;
            }
        }
    }
}

void ordenar1(int n) {
    disciplina tmp;
    for (int i = 0; i < discsem[n] - 1; i++) {
        for (int j = i; j < discsem[n]; j++) {
            if (strcmp(semestre[n][i].name, semestre[n][j].name) > 0) {
                tmp = semestre[n][i];
                semestre[n][i] = semestre[n][j];
                semestre[n][j] = tmp;
            }
        }
    }
}

int main() {
    int n, m;
    int k;
    char strdisc[8];
    int posdisc;
    int posdep;

    while (1) {
        scanf("%d %d", &n, &m);
        if (n == 0 && m == 0)
            break;

        ndisc = 0;
        for (int i = 0; i < MAX; i++) {
            vdisc[i].cod = i;
            vdisc[i].name[0] = '\0';
            vdisc[i].grau = 0;
            vdisc[i].ativ = 1;
            vdisc[i].rem = 0;
        }

        for (int i = 0; i < n; i++) {
            scanf("%s", strdisc);
            posdisc = finddisc(strdisc);
            if (posdisc == -1) {
                strcpy(vdisc[ndisc].name, strdisc);
                posdisc = ndisc;
                ++ndisc;
            }
            scanf("%d", &k);
            for (int j = 0; j < k; j++) {
                scanf("%s", strdisc);
                posdep = finddisc(strdisc);
                if (posdep == -1) {
                    strcpy(vdisc[ndisc].name, strdisc);
                    posdep = ndisc;
                    ++ndisc;
                }
                adisc[posdisc][vdisc[posdisc].grau] = posdep;
                vdisc[posdisc].grau++;
            }
        }

        nsemestre = 0;
        while (1) {
            sizelista = 0;
            if (!DFS())
                break;
            ordenar();

            discsem[nsemestre] = (m < sizelista) ? m : sizelista;

            for (int i = 0; i < m; i++) {
                if (i < sizelista) {
                    vdisc[listadisc[i]].ativ = 0;
                    semestre[nsemestre][i] = vdisc[listadisc[i]];
                }
            }

            ordenar1(nsemestre);

            nsemestre++;
        }

        printf("Formatura em %d semestres\n", nsemestre);
        for (int i = 0; i < nsemestre; i++) {
            printf("Semestre %d :", i + 1);
            for (int j = 0; j < discsem[i]; j++) {
                printf(" %s", semestre[i][j].name);
            }
            printf("\n");
        }
    }

    return 0;
}